using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        int N = int.Parse(Console.ReadLine());
        var points = new List<(int, int)>();

        for (int i = 0; i < N; i++)
        {
            var coordinates = Console.ReadLine().Split();
            int x = int.Parse(coordinates[0]);
            int y = int.Parse(coordinates[1]);
            points.Add((x, y));
        }

        long totalGreetings = 0;
        var visited = new Dictionary<(int, int), int>();

        foreach (var (x, y) in points)
        {
            var moves = new List<(int, int)>
            {
                (x + 1, y), (x - 1, y), (x, y + 1), (x, y - 1)
            };

            foreach (var (nx, ny) in moves)
            {
                if (visited.ContainsKey((nx, ny)))
                {
                    totalGreetings += visited[(nx, ny)];
                }
            }

            foreach (var (nx, ny) in moves)
            {
                if (!visited.ContainsKey((nx, ny)))
                {
                    visited[(nx, ny)] = 0;
                }
                visited[(nx, ny)]++;
            }
        }

        Console.WriteLine(totalGreetings);
    }
}